# WAbsensi v2.0.0 - cPanel Compatible Edition

WhatsApp Bot untuk sistem absensi dengan geofencing menggunakan Baileys library. Versi ini dioptimasi khusus untuk cPanel dan shared hosting.

## 🚀 Fitur Utama

- ✅ **Absensi dengan Geofencing** - Validasi lokasi dalam radius 100m
- 📱 **WhatsApp Bot** menggunakan Baileys (tanpa Puppeteer)
- 🌐 **Web Interface** untuk scan QR Code
- 📊 **Google Sheets Integration** untuk penyimpanan data
- 🏥 **Multi-location Support** - 14 titik lokasi terdaftar
- 🔐 **Admin Commands** untuk management
- 📝 **Detailed Logging** dengan informasi participant
- 🔄 **Auto-reconnect** dan error handling

## 🏗️ Keunggulan cPanel Version

- 🚫 **Tidak memerlukan Puppeteer** (kompatibel shared hosting)
- ⚡ **Memory efficient** dengan monitoring
- 🔄 **Auto-restart** pada error
- 📦 **Optimized dependencies** versi terbaru
- 🌍 **Environment-based configuration**
- 🛡️ **Enhanced security** dengan API key management

## 📦 Instalasi

### Prasyarat
- Node.js 18+ 
- NPM atau Yarn
- cPanel dengan Node.js support
- WhatsApp account

### Langkah Instalasi

1. **Clone atau upload project ke cPanel**
```bash
# Upload semua file ke directory di cPanel
# Pastikan struktur folder sesuai
```

2. **Install dependencies**
```bash
npm install
```

3. **Konfigurasi environment**
```bash
# Edit file .env sesuai kebutuhan
```

4. **Jalankan deployment script**
```bash
chmod +x deploy-cpanel.sh
./deploy-cpanel.sh
```

5. **Start aplikasi**
```bash
node index.js
```

## 🔧 Konfigurasi

### File `.env`
```env
NODE_ENV=production
PORT=9001
BOT_NAME=WAbsensi-Bot
BOT_VERSION=2.0.0-Baileys
CPANEL_MODE=true
API_KEY=your-api-key-here
GOOGLE_SHEETS_DEPLOY_ID=your-sheets-deploy-id
LOG_LEVEL=info
```

### cPanel Setup

1. **Node.js App di cPanel:**
   - Application URL: `/path/to/wabot_cpanel`
   - Startup File: `index.js`
   - Environment: `NODE_ENV=production`

2. **Port Configuration:**
   - Pastikan port 9001 terbuka
   - Atau sesuaikan dengan port yang tersedia

## 🌐 Web Interface

- **Home Page:** `http://your-domain.com:9001/`
- **QR Scanner:** `http://your-domain.com:9001/scan`
- **Status Check:** `http://your-domain.com:9001/check-status`

## 📱 WhatsApp Commands

### User Commands
- `ping` - Test bot response
- `absen` - Instruksi untuk absensi
- `#lokasilist` - Daftar lokasi yang diizinkan

### Admin Commands
- `#infogrup` - Info detail grup
- `#testlokasi [lat] [lon]` - Test koordinat lokasi
- `#manual|tanggal|jam` - Manual attendance

## 📍 Geofencing

Bot mendukung 14 lokasi dengan validasi radius 100 meter. Cara kerja:
1. User share live location di WhatsApp
2. Bot validasi koordinat dengan allowedLocations
3. Jika dalam radius 100m → Presensi berhasil
4. Jika di luar radius → Pesan penolakan dengan detail

## 🔌 API Endpoints

### Check Status
```
GET /check-status
Response: { connected: true, timestamp: "2025-01-01T00:00:00.000Z" }
```

### Check WhatsApp Number
```
GET /check-wa-number?idkey=API_KEY&wanumber=628xxx
```

### Send Message
```
GET /pm?idkey=API_KEY&wanumber=628xxx&message=Hello
```

## 📊 Google Sheets Integration

Bot terintegrasi dengan Google Apps Script untuk menyimpan data absensi. Setup:
1. Buat Google Spreadsheet untuk data absensi
2. Deploy Google Apps Script 
3. Copy Deployment ID ke environment variable

## 🚨 Troubleshooting

### Common Issues:

1. **Port already in use**
   - Ubah PORT di .env file
   - Check running processes

2. **Memory limit exceeded**
   - Enable CPANEL_MODE in .env
   - Monitor memory usage

3. **Connection failed**
   - Clear baileys_auth_info folder
   - Rescan QR Code

## 📈 Performance Tips

1. **Memory Management:** Enable CPANEL_MODE untuk monitoring
2. **Connection Stability:** Keep WhatsApp app closed on phone
3. **Error Handling:** Built-in graceful reconnection

---

**WAbsensi v2.0.0-Baileys** - Optimized for cPanel & Shared Hosting
